CREATE OR REPLACE FUNCTION addColumn() 
RETURNS VOID AS 
$BODY$ 
BEGIN 
	IF EXISTS (SELECT 1 FROM information_schema.columns 
					WHERE table_name= 'v_diagnostico_configuracao') THEN 
		DROP VIEW v_diagnostico_configuracao;
		RAISE NOTICE 'v_diagnostico_configuracao Dropada.';
	END IF;
	
	CREATE OR REPLACE VIEW public.v_diagnostico_configuracao
	AS SELECT a.cd_cx,
		b.cd_nf_serie,
		d.serial_cert,
		d.id_token,
		d.csc_token,
		coalesce(c.cd_nf, b.cd_nf_ini) as cd_nf,
		e.cd_filial,
		e.cd_cid AS codigocidcadastrofilial,
		f.cd_cid,
		f.cd_municipio_ibge,
		( SELECT i.valor
			   FROM prc_filial_config i
			  WHERE i.cd_chave::text ~~* '%ambiente_producao_nfce%'::text AND i.cd_filial = e.cd_filial) AS ambiente_producao_nfce,
		( SELECT i.valor
			   FROM prc_filial_config i
			  WHERE i.cd_chave::text ~~* '%url_consulta_nfce%'::text AND i.cd_filial = e.cd_filial) AS url_consulta_nfce
	   FROM pdv_cx a
		 LEFT JOIN pdv_cx_est_nf_serie b ON a.cd_emp = b.cd_emp AND a.cd_cx = b.cd_cx AND a.cd_filial = b.cd_filial
		 LEFT JOIN est_nfce_nr c ON c.cd_emp::numeric = b.cd_emp AND c.cd_filial::numeric = b.cd_filial AND c.cd_nf_serie::text = b.cd_nf_serie::text
		 LEFT JOIN pdv_cx_nfce d ON d.cd_emp = a.cd_emp AND d.cd_cx = a.cd_cx AND d.cd_filial = a.cd_filial
		 LEFT JOIN prc_filial e ON e.cd_emp = a.cd_emp AND e.cd_filial = a.cd_filial
		 LEFT JOIN glb_cid f ON f.cd_cid = e.cd_cid;
	
	RAISE NOTICE 'v_diagnostico_configuracao Recriada.';

END; 
-- fim bloco principal 
$BODY$ 
LANGUAGE plpgsql VOLATILE 
  COST 100; 
ALTER FUNCTION addColumn() OWNER TO postgres; 
SELECT addColumn(); 
DROP FUNCTION addColumn();
